//--------------------------------------------------------------------------
//
//  Software for MSP430 based e-meters.
//
//  You may not use the Program in non-TI devices.
//
//  File: emeter-communications.c
//
//  Steve Underwood <steve-underwood@ti.com>
//  Texas Instruments Hong Kong Ltd.
//
//  $Id: emeter-communication.c,v 1.7 2005/11/17 09:25:23 a0754793 Exp $
//
/*! \file emeter-structs.h */
//
//--------------------------------------------------------------------------
//

#include "Meter_Host4618.h"
#include "AFE_Communication.h"
#include "emeter-dlt645.h"

#include <isr_compat.h>

void csg_reserved_process()
{
}
void csg_newlog_process()
{
  afe_read_params();
}
void csg_zeroleading_process()
{
}
void csg_wfs_process()
{
}

////////////////////////////////////////////////////////////////////
///////////////////Global variables/////////////////////////////////
//csg flah
unsigned int gFlag;
//local status
unsigned char gStatus;
/* timeout for communication */
uint16_t char_timeout_1107;

volatile Word_Bit_type         Run_Flag;               //ִпλ
volatile Char_Bit_type         Meter_State;            //ܱ״̬λ
int8_t lcd_page;       //lcd dispaly page #

/* Meter status flag bits. */
uint16_t meter_status;

void (*int_serv[8])() = {
  csg_newlog_process,
  csg_zeroleading_process,
  csg_reserved_process,
  csg_reserved_process,
  csg_reserved_process,
  csg_reserved_process,
  csg_reserved_process,
  csg_wfs_process,
}; 

//for test
int g_reg_value1 = 0;
unsigned int g_interval = 42000;
////////////////////////////////////////////////////////////////////
/////////////////////metrology data///////////////////////////////
struct csg_phase_parms_s meter1;

void init()
{
  phase->active_power[0] = 1;
  phase->active_power[1] = 2;
  phase->reactive_power[0] = 3;
  phase->reactive_power[1] = 4;
  phase->apparent_power[0] = 5;
  phase->apparent_power[1] = 6;
  phase->V_rms = 8;
  phase->I_rms[0] = 9;
  phase->I_rms[1] = 10;

  phase_nv->current[0].P_scale_factor[0] = 11;
  phase_nv->current[1].P_scale_factor[0] = 12;
  phase_nv->current[0].Phase_correction[0] = 13;
  phase_nv->current[1].Phase_correction[0] = 14;
  phase_nv->current[0].Offset_active_power = 15;
  phase_nv->current[1].Offset_active_power = 16;
  phase_nv->current[0].Offset_reactive_power = 17;
  phase_nv->current[1].Offset_reactive_power = 18;
  phase_nv->current[0].Ac_offset = 19;
  phase_nv->current[1].Ac_offset = 20;
  phase_nv->current[0].I_rms_scale_factor[0] = 21;
  phase_nv->current[1].I_rms_scale_factor[0] = 22;
  
  phase_conf->gSysconf = 23;
  phase_conf->gCsgconf = 24;
  phase_conf->gPower_const = 25;
  phase_conf->gStart_curr = 26;
  
  
  gFlag = 0;
  gStatus = 0;
  
  return;
}

///////////////////////////////////////////////////////////////////////
/////////////////////static functions///////////////////////////////
///////////////////////////////////////////////////////////////////////
/*****************************************************************
ProcHalf
ڲ
ڲ
: ʱֽµز
ƣhls
******************************************************************/
void Proc_Half( void )
{
    static volatile unsigned char BT_CNT=0;
    
    BT_CNT++;
    if(BT_CNT == 2){
      SEC_FLAG = 1;
      BT_CNT = 0;
    }
    
    if(P6OUT&BIT6)
       P6OUT = 0x00;
    else
       P6OUT = BIT6;          

}
/*****************************************************************
ProcSec
ڲ
ڲ
: ʱֽµز
ƣhls
******************************************************************/
void Proc_SEC(void)
{
    SEC_FLAG = 0;
//    DISP_FLAG = 1;  
    afe_read_params();
    afe_read_calibrations();
    afe_read_configurations();

}

//////////////////////////////////////////////////////////
////////////communication, related to device
/////////////////////////////////////////////////////////
void send_msg(int len)
{
    tx_msg[0].ptr = 0;
    tx_msg[0].len = len;
        
    UC0IE |= UCA0TXIE;
}
int is_calibration_enabled(void)
{
    return TRUE;
}
///////////////////////////////////////////////////////////////////////
/////////////////////main()///////////////////////////////
///////////////////////////////////////////////////////////////////////
void main(void)
{
  volatile unsigned int i;

  WDTCTL = WDTPW+WDTHOLD;                   // Stop watchdog timer
  FLL_CTL0 |= DCOPLUS + XCAP18PF;                     // Configure load caps


  // Wait for xtal to stabilize
  do
  {
  IFG1 &= ~OFIFG;                           // Clear OSCFault flag
  for (i = 0x47FF; i > 0; i--);             // Time for flag to set
  }
  while ((IFG1 & OFIFG));                   // OSCFault flag still set?

  SCFI0 = FN_3 | FLLD_4;
  SCFQCTL = 32 - 1;  
  

  SVSCTL = SVSON + PORON + VLD2 + VLD1;               // SVSģ飬Ϊ2.5  

  P1IES|=0x01;    //bit0 as interrupt in
  P1IE|=0x01;
  
  P1DIR = 0x22;                             // P1.1 & P1.5 to output direction
  P1SEL = 0x22;                             // P1.1 & P1.5 to output MCLK & ACLK

  //LSD_V1.0
//  P2IES = BIT3|BIT6;     //Button used to swich LCD display
//  P2IE = BIT3|BIT6;     //Button used to swich LCD display
  
  //LSD_V3.0
  P1IES |= BIT2|BIT4;     //Button used to swich LCD display
  P1IE |= BIT2|BIT4;     //Button used to swich LCD display
  
  P2SEL |= BIT4|BIT5;    //UART0
  P2DIR |= BIT4;          //TX0  
  
  P3OUT |= BIT3;
  P3DIR |= BIT3;
    /*************************  Port P5ʼ ***********************/
  P5OUT = 0;
  P5DIR = 0xFF;
  P5SEL = COM1 | COM2 | COM3 | R33 | R23 | R13;                        //LCD˿ڵĹ˺S0S1  
  
  P6DIR |= BIT5 | BIT6;
  P6OUT |= BIT5 | BIT6;
  
  P1IES|=0x01;    //bit0 as interrupt in
  P1IE|=0x01;
  
  P1DIR = 0x22;                             // P1.1 & P1.5 to output direction
  P1SEL = 0x22;                             // P1.1 & P1.5 to output MCLK & ACLK

  //////////////////* Configure USART1 for AFE*/ SPI MASTER
  P4SEL |= 0x038;                           // P4.5,4.4,4.3 SPI option select UCLK, SOMI, SIMO
  P4DIR |= 0x28;                            // P4.5,4.3 as outputs
  U1CTL = CHAR+SYNC+MM+SWRST;               // 8-bit, SPI, Master
  U1TCTL |= SSEL1+STC;                      // Polarity, SMCLK(4MHz), 3-wire
//U1TCTL |= SSEL1;                      // Polarity, SMCLK(4MHz), 4-wire
  P4DIR |= BIT2;
  P4OUT |= BIT2;
  U1BR0 = 0x008;                            // SPICLK = SMCLK/8
  U1BR1 = 0x000;                            //
//U1BR0 = 0x000;                            // SPICLK = SMCLK/512
//U1BR1 = 0x001;                            //
  U1MCTL = 0x000;                           //
  ME2 |= USPIE1;                            // Module enable
  U1CTL &= ~SWRST;                          // SPI enable

//--- Initialization of RS232 Commuinication for host(USCI_A) --------------------------
  P2SEL |= 0x030;                           // P2.4,5 = USCI_A0 RXD/TXD
  UCA0CTL1 |= UCSSEL_2;                     // SMCLK
#if defined(BAUTRATE_115200)
  UCA0BR0 = 0x09;                           // 1MHz 115200
  UCA0BR1 = 0x00;                           // 1MHz 115200
  UCA0MCTL = 0x02;                          // Modulation
#elif defined(BAUTRATE_19200)
  UCA0BR0 = 0x36;                           // 1MHz 19200
  UCA0BR1 = 0x00;                           // 1MHz 19200
  UCA0MCTL = 0x0A;                          // Modulation
#elif defined(BAUTRATE_9600)
//  UCA0BR0 = 0x6A;                           // 8.3MHz 9600
//  UCA0BR1 = 0x03;                           // 8.3MHz 9600
  UCA0BR0 = 0xb4;                           // 4.2MHz 9600
  UCA0BR1 = 0x01;                           // 4.2MHz 9600
  UCA0MCTL = 0x04;                          // Modulation  UCA0CTL1 &= ~UCSWRST;                     // **Initialize USCI state machine**
#endif  
  UCA0CTL1 &= ~UCSWRST;                     // **Initialize USCI state machine**
  IE2 |= UCA0RXIE;                          // Enable USCI_A0 RX interrupt

  
//--- Initialization TimerA for timeout control ----------------------------
  //CCTL0 = CCIE;                             // CCR0 interrupt enabled
  //CCR0 = TIMEROUT_AFE_READ;                  // 1s
    TACTL = TASSEL_1 + MC_2;                  // ACLK, continous mode
  
//////////////////init BT///////////////////////
    BT_Init();                                      // ʱ125ms
//////////////////init LCD///////////////////////

    for( unsigned char i = 0;i < 20;i++ )
        LCD_Write(i,0xFF);  
    //test LCD
    for( unsigned long j=0;j<50000;j++); 
    
//--- Main Loop ----------------------------------------------------------------
  init();
  
  IE2 |= BTIE;
  _EINT();
  
//  afe_write_message[0] = 0x68;      
//  afe_read_calibrations();//read calibration constant from AFE
  
#if 1  //FOR TEST
//  while(1)
  {
//    afe_read(0x5A);
//    prepare_afe_write(AFE_CMD_SET_WREN, 0xc500, 5); 
//    for(int i = 0; i<30000; i++);
//    prepare_afe_write(AFE_CMD_SET_METER_START_CURRENT, 100, 5); 
//    for(int i = 0; i<30000; i++);
//    afe_read(g_tmp);
//    for(int i = 0; i<30000; i++);
  }
#endif
  
  while(1)
  { 
    if( gFlag & FL_AFE_INTERRUPT_IN ){       
      gFlag &= ~FL_AFE_INTERRUPT_IN;              
      afe_read_ifg();        
    }
    else if(gFlag & FL_HST_READ_AFE_CAL){
      gFlag &= ~FL_HST_READ_AFE_CAL;
      //read calibration registers from AFE
    }
    else if(gFlag & FL_HST_READ_AFE_CONF){
      gFlag &= ~FL_HST_READ_AFE_CONF;
      //read configuration register from AFE
    }    
    else if(gFlag & FL_HST_SET_AFE_CAL){
      gFlag &= ~FL_HST_SET_AFE_CAL;
      //set AFE calibration registers
      afe_set_calibrations();
    }    
    else if(gFlag & FL_HST_SET_AFE_REG){
      gFlag &= ~FL_HST_SET_AFE_REG;
      //set AFE calibration registers
      afe_set_registers();
    } 
    //this is used for test
    else if(gFlag & FL_SELFTEST_KICKER){
      gFlag &= ~FL_SELFTEST_KICKER;
      prepare_afe_write(AFE_CMD_SET_WREN, AFE_WREN_REG, 5); 
      for(i = 0; i<8000; i++);  //6000 count delay 10ms at 4MHz MCLK. At least 7000 count needed to garentee successful operation.
      prepare_afe_write(AFE_CMD_SET_METER_START_CURRENT, g_reg_value1, 5); 
      for(i = 0; i<g_interval; i++);  //1ms at 4MHz MCLK

    }

    
    if( phase_conf->int_flag ){
      for( i = 0; i < 8; i++ ){
        if( phase_conf->int_flag&(0x01<<i) )
          int_serv[i]();
//        if( meter1.int_flag&0x01 )
//          if( gFlag & FL_AFE_READING_OUT_EN ){
//            if(gFlag &FL_AFE_READING_OUT_CH)                      
//              send_AFE_reading(1);
//            else
//              send_AFE_reading(0);  
//          }
      }
      phase_conf->int_flag = 0;
    }
  
    if( BT_FLAG )          
    {
      Proc_SEC();               
      Display_Operation(lcd_page);
      BT_FLAG = 0;
    }
  }
}

//////////////////////////////////////////////////////////////////////////
////////interrupt sevice routine////////////////////////////
//////////////////////////////////////////////////////////////////////////////

////////////////////////////AFE communication
ISR(USART1RX, serial_rx_interrupt1)
{
  if(afe_read_msg_ptr < AFE_READ_PACKET_SIZE){
    afe_read_message.uint8[afe_read_msg_ptr++] = RXBUF1;
    if(afe_read_msg_ptr == AFE_READ_PACKET_SIZE){
      afe_read_msg_ptr = 0;
      gFlag |= FL_AFE_READ;
      gStatus &= ~ST_AFE_READING;
      IE2 &= ~URXIE1;
    }
    else{   
      U1TXBUF = 0x00;          // Dummy write to read next byte   

      TACCTL2 = CCIE;                          // CCR2 interrupt enabled to set 1ms interval for SPI read
      gStatus &= ~ST_AFE_INTERVAL_REACHED;
      CCR2 = TAR + INTERVAL_BETWEEN_BYTES;
    }
  }
  /* Stop responds to rx vector for 1ms delay*/
  IE2 &= ~URXIE1;   
  
}

ISR(USART1TX, serial_tx_interrupt1)
{
    if (afe_write_msg_ptr < afe_write_msg_len){
      TXBUF1 = afe_write_message[afe_write_msg_ptr++];

      TACCTL2 &= ~CCIE;                          // CCR2 interrupt disabled to set 1ms interval for SPI write
      TACCTL1 = CCIE;                          // CCR1 interrupt enabled to set 1ms interval for SPI write
      gStatus &= ~ST_AFE_INTERVAL_REACHED;
      CCR1 = TAR + INTERVAL_BETWEEN_BYTES;
    }
    else{
        afe_write_msg_ptr = 0;
        afe_write_msg_len = 0;
        gStatus &= ~ST_AFE_WRITING;

        if(gStatus&ST_AFE_READING){//meter read command? enable receiving    
          U1TXBUF = 0x00;          // Dummy write to start read          

          TACCTL1 &= ~CCIE;                          // CCR1 interrupt disabled to set 1ms interval for SPI write
          TACCTL2 = CCIE;                          // CCR2 interrupt enabled to set 1ms interval for SPI read
          gStatus &= ~ST_AFE_INTERVAL_REACHED;
          CCR2 = TAR + INTERVAL_BETWEEN_BYTES;
        }
        else
          P4OUT |= BIT2;                            //stop com
    }

    /* Stop transmission for 1ms delay*/
    IE2 &= ~UTXIE1;   
}

/////////////////////////////////////Host communication
//  Echo back RXed character, confirm TX buffer is ready firstp=
#pragma vector=USCIAB0RX_VECTOR
__interrupt void USCIA0RX_ISR (void)
{
    unsigned char ch;
    ch = UCA0RXBUF;
    
    dlt645_rx_byte(0, ch);
}

ISR(USCIAB0TX, host_tx_interrupt0)
{
    UCA0TXBUF = tx_msg[0].buf.uint8[tx_msg[0].ptr++];
    if (tx_msg[0].ptr >= tx_msg[0].len)
    {
        /* Stop transmission */
        UC0IE &= ~UCA0TXIE;   
        tx_msg[0].ptr = 0;
        tx_msg[0].len = 0;
    }
}

/////////////////////////////////////timeout control for CSG read
// 
#pragma vector=TIMERA0_VECTOR
__interrupt void Timer_A (void)
{
  if(gStatus&ST_AFE_READING){
    gStatus &= ~ST_AFE_READING;
    gStatus |= ST_AFE_READING_TOUT;    
  }
}
//////////////////////////////////////timeout control for CSG write, to get 1ms interval between sent bytes to CSG
#pragma vector=TIMERA1_VECTOR
__interrupt void TIMERA1_VECTOR_ISR (void)
{
  switch( TAIV )
  {
  case  2: 
    gStatus |= ST_AFE_INTERVAL_REACHED;
    IE2 |= UTXIE1; 
    TACCTL1 &= ~CCIE;     // CCR1 interrupt disable
    break;
  case  4: 
    gStatus |= ST_AFE_INTERVAL_REACHED;
    IE2 |= URXIE1; 
    TACCTL2 &= ~CCIE;     // CCR2 interrupt disable           
    break;
  case 10: P1OUT ^= 0x08;                   // Timer_A3 overflow
           break;
 }  
  
}

///////////////////base timer for 125ms
ISR(BASICTIMER,ISR_BT)
{
    BT_FLAG = 1;
}

/****************************************************************
ISR_PORT2
ڲ
ڲ
: Port2I/O˿жϷӳ
*****************************************************************/
//LSD_V3.0
ISR(PORT1,ISR_PORT1)
{
    
    if(P1IFG&BIT2)                 //ʾ£ִлҳ
    {
        if((P1IN&BIT2) == 0)
            for(int i = 0;i<1000;i--);
        if((P1IN&BIT2) == 0)
        {
            if( ++lcd_page > DISP_PAGE)
                lcd_page = 0;
        }
    }
    if(P1IFG&BIT4)                 //ʾ£ִлҳ
    {
        if((P1IN&BIT4) == 0)
            for(int i = 0;i<1000;i--);
        if((P1IN&BIT4) == 0)
        {
            if( --lcd_page < 0)
                lcd_page = DISP_PAGE;
        }
    }    
    P1IFG = 0;

//test AFE write
//    gFlag |= FL_SELFTEST_KICKER;
//test UART0    
//  U0TXBUF = 'S';                 // send 'SPI:' via RS232
//  while (!(IFG1 & UTXIFG0));                // USART0 TX buffer ready?
//  U0TXBUF = 'P';
//  while (!(IFG1 & UTXIFG0));                // USART0 TX buffer ready?
//  U0TXBUF = 'I';
//  while (!(IFG1 & UTXIFG0));                // USART0 TX buffer ready?
//  U0TXBUF = ':';
//  while (!(IFG1 & UTXIFG0));                // USART0 TX buffer ready?
//  U0TXBUF = '"';
//  while (!(IFG1 & UTXIFG0));                // USART0 TX buffer ready?
//
//  U0TXBUF = '"';                 // send '"' via RS232
//  while (!(IFG1 & UTXIFG0));                // USART0 TX buffer ready?
//  U0TXBUF = 10;                  // send carriage return via RS232
//  while (!(IFG1 & UTXIFG0));                // USART0 TX buffer ready?
//  U0TXBUF = 13;
//  while (!(IFG1 & UTXIFG0));                // USART0 TX buffer ready?

}